#include <stdio.h>
#include <stdlib.h>

struct item
{
	int data;
	struct item *next;
};

void push(struct item **phead, int a)
{
	struct item *n = malloc(sizeof(*n));
	n->data = a;
	n->next = *phead;
	*phead = n;
}

void pop(struct item **phead)
{
	struct item *p = (*phead)->next;
	free(*phead);
	*phead = p;
}

void foreach(struct item *head, void (*f)(int))
{
		struct item *p;
		for (p = head; p; p = p->next)
				f(p->data);
}

void print_int(int a) { printf("%d\n", a); }
int sum = 0;
void sum_int(int a) { sum += a; }

int main()
{
	struct item *head = NULL;

	push(&head, 1);
	push(&head, 2);
	push(&head, 3);

	foreach(head, print_int);
	foreach(head, sum_int);
	printf("sum: %d\n", sum);

	while (head)
	{
		pop(&head);
	}

	return 0;
}
