#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct human
{
	char *name;
	int year;
};

void print(struct human *p, int N)
{
		int i;
		for (i = 0; i < N; i++)
		{
				printf("name: %s, year: %d\n", p[i].name, p[i].year);
		}
}

// callback function - "  "
int sort_by_name(const void *p1, const void *p2)
{
		return strcmp(((struct human *)p1)->name, 
						((struct human *)p2)->name);
}

int sort_by_year(const void *p1, const void *p2)
{
		return ((struct human *)p1)->year - 
				((struct human *)p2)->year;
}

int main()
{
	struct human A[3] = {
		{ "vasya", 1990 }, 
		{ "petya", 1991 }, 
		{ "kolya", 1989 },
	};

	print(A, 3);

	printf("sorted by name:\n");
	qsort(A, 3, sizeof(*A), sort_by_name);
	print(A, 3);
	
	printf("sorted by year:\n");
	qsort(A, 3, sizeof(*A), sort_by_year);
	print(A, 3);
	

	return 0;
}
