#include <stdio.h>
#include <stdlib.h>

struct item
{
	int data;
	struct item *next;
};

void push(struct item **phead, struct item **ptail, int a)
{
	struct item *p = malloc(sizeof(*p));
	p->data = a;
	p->next = *phead;
	*phead = p;
	if (!*ptail)
	{
		*ptail = p;
	}
}

void print(struct item *head)
{
	struct item *p;
	for (p = head; p; p = p->next)
	{
		printf("%d ", p->data);
	}
	printf("\n");
}

void pop(struct item **phead, struct item **ptail)
{
	struct item *q = (*phead)->next;
	free(*phead);
	*phead = q;
	if (!*phead)
	{
		*ptail = NULL;
	}
}

int empty(struct item *head)
{
	return (head == NULL);
}

void insert_last(struct item **phead, struct item **ptail, int a)
/*        
 */
{
	struct item *p;
	if (!*phead)
	{
		push(phead, ptail, a);
		return;
	}
	p = malloc(sizeof(*p));
	p->data = a;
	p->next = NULL;
	(*ptail)->next = p;
	*ptail = p;
}

int main()
{
	struct item *head = NULL, *tail = NULL;
	int a;

	while (scanf("%d", &a) == 1)
	{
		insert_last(&head, &tail, a);
	}

	print(head);

	while (!empty(head))
	{
		pop(&head, &tail);
	}

	return 0;
}
